/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils.schema;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.listener.utils.Constants;
import filenet.ws.utils.schema.ISchemaLoader;
import filenet.ws.utils.schema.WSSchemaUtilsEx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;

public class PESchemaHelper
implements ISchemaLoader {
    protected static Logger logger = Logger.getLogger("filenet.ws.utils.schema");
    protected static final String m_className = "PESchemaHelper";
    protected static SchemaFileCache G_SCHEMAFILECACHE = new SchemaFileCache();
    private VWSession m_vwSession = null;
    private String m_schema = null;
    boolean fromServer = false;
    private String m_rootContext = "";
    private String m_curSchemaText = null;
    private String P8BPMWSBrokerServerXSDPath = null;

    public static WSSchemaUtilsEx GetSchemaFromServer(VWSession vwSession, String schemaFileName, String soapAddress) throws VWException {
        PESchemaHelper h = new PESchemaHelper(vwSession, soapAddress);
        return h.getSchemaFromServer(schemaFileName);
    }

    public static WSSchemaUtilsEx GetSchemaFromText(VWSession vwSession, String schemaText, String soapAddress) throws VWException {
        PESchemaHelper h = new PESchemaHelper(vwSession, soapAddress);
        WSSchemaUtilsEx ws = h.getSchemaFromText(schemaText);
        ws.setFromServer(false);
        return ws;
    }

    public static WSSchemaUtilsEx GetSchemaFromURL(VWSession vwSession, URL url) throws VWException {
        return new WSSchemaUtilsEx(url.toString(), null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ClearCache() {
        SchemaFileCache schemaFileCache = G_SCHEMAFILECACHE;
        synchronized (schemaFileCache) {
            G_SCHEMAFILECACHE.EmptyCache();
        }
    }

    protected PESchemaHelper(VWSession vwSession, String soapAddress) {
        int i;
        this.m_vwSession = vwSession;
        if (soapAddress != null && (i = soapAddress.indexOf("P8BPMWSBroker")) > 0) {
            this.P8BPMWSBrokerServerXSDPath = soapAddress.substring(0, i + "P8BPMWSBroker".length()) + Constants._XSD_;
        }
    }

    protected WSSchemaUtilsEx getSchemaFromServer(String serverFileName) throws VWException {
        if (serverFileName != null && serverFileName.trim().length() > 0) {
            this.m_schema = serverFileName.replace('\\', '/');
        }
        if (this.m_schema != null) {
            this.fromServer = true;
            int lastSlash = this.m_schema.lastIndexOf(47);
            if (lastSlash != -1) {
                this.m_rootContext = this.m_schema.substring(0, lastSlash);
                this.m_schema = this.m_schema.substring(lastSlash + 1);
            }
            if (this.m_rootContext.endsWith("/")) {
                this.m_rootContext = this.m_rootContext.substring(0, this.m_rootContext.lastIndexOf(47));
            }
            this.m_rootContext = this.m_rootContext.trim();
            URL initialSchemaURL = this.GetSchema(null, this.m_schema);
            return new WSSchemaUtilsEx(this.m_curSchemaText, initialSchemaURL.toString(), this, false);
        }
        throw new VWException("filenet.ws.utils.schema.PESchemaHelper.NoServerSchemaFileSpecified", "No server schema file was specified.");
    }

    protected WSSchemaUtilsEx getSchemaFromText(String schemaText) throws VWException {
        return new WSSchemaUtilsEx(schemaText, null, this, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL GetSchema(String contextURL, String fileName) throws VWException {
        String m_method = "GetSchema:" + fileName;
        try {
            String path = null;
            if (fileName.startsWith(Constants._XSD_)) {
                path = fileName.substring(Constants._XSD_.length());
            } else {
                boolean wantParentDir;
                String origFileName = fileName;
                if (fileName.startsWith("./")) {
                    fileName = fileName.substring(2);
                }
                if (wantParentDir = fileName.startsWith("../")) {
                    fileName = fileName.substring(2);
                    int lastSlash = this.m_rootContext.lastIndexOf(47);
                    if (lastSlash == -1) {
                        if (this.m_rootContext.length() <= 0) throw new VWException("filenet.ws.utils.schema.PESchemaHelper.GetSchema.InvalidFileName", "{0} is invalid.  Already at the root level.", origFileName);
                        path = fileName;
                    } else {
                        path = this.m_rootContext.substring(0, lastSlash) + fileName;
                    }
                } else {
                    path = this.m_rootContext + "/" + fileName;
                }
            }
            URL res = G_SCHEMAFILECACHE.existLocally(path);
            if (res == null) {
                this.m_curSchemaText = this.m_vwSession.fetchFileFromServer(path, 1);
                res = G_SCHEMAFILECACHE.storeLocally(path, this.m_curSchemaText);
            }
            if (this.P8BPMWSBrokerServerXSDPath == null) return res;
            String s = this.P8BPMWSBrokerServerXSDPath + path;
            return new URL(s);
        }
        catch (VWException vwex) {
            throw vwex;
        }
        catch (Exception e) {
            VWException vwex = new VWException("filenet.ws.utils.schema.PESchemaHelper.GetSchemaFailure", "Failed to get schema for {0}. ex={1}", fileName, e.getLocalizedMessage());
            vwex.setCause(e);
            throw vwex;
        }
    }

    public String NormalizePath(String contextURL, String path) {
        int i = contextURL.indexOf(Constants._XSD_);
        if (i != -1) {
            return contextURL.substring(i);
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "NormalizePath", path);
        }
        return path;
    }

    public URL StoreSchema(String schema) throws VWException {
        try {
            return G_SCHEMAFILECACHE.storeTemporarily(schema);
        }
        catch (Exception e) {
            VWException vwex = new VWException("filenet.ws.utils.schema.PESchemaHelper.GetSchemaFailure", "Failed to store temporary schema. Ex={0}", e.getLocalizedMessage());
            vwex.setCause(e);
            throw vwex;
        }
    }

    public static void main(String[] args) {
        VWSession ses = null;
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            String ceURI = c.getParameter("ceURI", "http://hqamber:9080/wsi/FNCEWS40DIME/");
            String cp = c.getParameter("cp", "hqruby_600");
            String username = c.getParameter("username", "PEAdmin");
            String password = c.getParameter("password", "WFQA20zz");
            String soapAddress = c.getParameter("soapAddress");
            ses = new VWSession();
            ses.setBootstrapCEURI(ceURI);
            ses.logon(username, password, cp);
            int nItems = c.getIntParameter("nItems", 1);
            for (int i = 1; i <= nItems; ++i) {
                String item = c.getParameter("schemaFileName" + i);
                if (item == null) continue;
                System.out.println("----------- GETTING and VALIDATING " + item + " ---------");
                try {
                    WSSchemaUtilsEx ws = null;
                    try {
                        URL url = new URL(item);
                        ws = PESchemaHelper.GetSchemaFromURL(ses, url);
                    }
                    catch (Exception e) {
                        ws = PESchemaHelper.GetSchemaFromServer(ses, item, soapAddress);
                    }
                    if (soapAddress != null) {
                        String mainSchema = ws.getMainSchema();
                        System.out.println("MAIN SCHEMA");
                        System.out.println(mainSchema);
                    } else {
                        System.out.println("*** VALIDATING Schema:\n" + ws.validate().toString());
                    }
                    String[] elements = ws.getSchemaElements();
                    int nElements = elements == null ? 0 : elements.length;
                    System.out.println("--- getSchemaElements returned " + nElements);
                    for (int n = 0; n < nElements; ++n) {
                        System.out.println("\nElement [" + n + "]\t" + elements[n]);
                        String schemaName = "TEST" + n;
                        System.out.println("\ngetXMLTemplate=[" + ws.getXMLTemplate(schemaName, elements[n]) + "]");
                        String[] schemas = ws.getSchemas();
                        int nSchemas = schemas == null ? 0 : schemas.length;
                        for (int s = 0; s < nSchemas; ++s) {
                            System.out.println("getExpressionTemplate=[" + ws.getExpressionTemplate(schemaName, schemas[s], elements[n]) + "]");
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Press a Key..");
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PESchemaHelper.ClearCache();
    }

    private static class SchemaFileCache {
        private HashMap FileCache = new HashMap();
        private File TempDir = null;

        protected static void DeleteFileObject(File fObject, boolean force) throws Exception {
            String m_method = "DeleteFileObject";
            String path = fObject.getCanonicalPath();
            if (fObject.isDirectory()) {
                int nChildren;
                File[] fContents = fObject.listFiles();
                int n = nChildren = fContents == null ? 0 : fContents.length;
                if (nChildren > 0) {
                    if (force) {
                        for (int i = 0; i < nChildren; ++i) {
                            SchemaFileCache.DeleteFileObject(fContents[i], force);
                        }
                    } else {
                        logger.finest(PESchemaHelper.m_className, "DeleteFileObject", path + " directory is not empty.  No deletion was done..");
                        throw new Exception(path + " directory not empty. ");
                    }
                }
            }
            boolean ok = fObject.delete();
            if (logger.isFinest()) {
                logger.finest(PESchemaHelper.m_className, "DeleteFileObject", path + " removed" + (ok ? "" : " NOT") + " OK");
            }
        }

        private void initTempDir() throws Exception {
            if (this.TempDir != null) {
                return;
            }
            File fTempDir = File.createTempFile("PESchema", null);
            String sTempDir = fTempDir.getCanonicalPath();
            fTempDir.delete();
            this.TempDir = new File(sTempDir + Constants._XSD_);
            this.TempDir.mkdirs();
            this.TempDir.deleteOnExit();
        }

        protected SchemaFileCache() {
        }

        public void EmptyCache() {
            this.FileCache.clear();
            try {
                if (this.TempDir != null) {
                    SchemaFileCache.DeleteFileObject(this.TempDir, true);
                    this.TempDir.getParentFile().delete();
                    this.TempDir = null;
                }
            }
            catch (Exception e) {
                logger.throwing(PESchemaHelper.m_className, "EmptyCache", e);
            }
        }

        protected void finalize() {
            this.EmptyCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL existLocally(String path) {
            URL f = (URL)this.FileCache.get(path);
            if (f != null && new File(f.toString()).exists()) {
                return f;
            }
            HashMap hashMap = this.FileCache;
            synchronized (hashMap) {
                this.FileCache.remove(path);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL storeLocally(String path, String text) throws Exception {
            Serializable serializable;
            String m_method = "FileCache.storeLocally".intern();
            OutputStreamWriter out = null;
            try {
                this.initTempDir();
                File newFile = new File(this.TempDir, path);
                newFile.getParentFile().mkdirs();
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF-8");
                out.write(text);
                URL res = newFile.toURL();
                serializable = this.FileCache;
                synchronized (serializable) {
                    this.FileCache.put(path, res);
                }
                if (logger.isFinest()) {
                    logger.finest(PESchemaHelper.m_className, m_method, path + ">>" + res.toString());
                }
                serializable = res;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return serializable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL storeTemporarily(String text) throws Exception {
            URL uRL;
            String m_method = "FileCache.storeTemporarily".intern();
            OutputStreamWriter out = null;
            try {
                this.initTempDir();
                File newFile = File.createTempFile("MAIN", "_xsd", this.TempDir);
                newFile.getParentFile().mkdirs();
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF-8");
                out.write(text);
                URL res = newFile.toURL();
                if (logger.isFinest()) {
                    logger.finest(PESchemaHelper.m_className, m_method, res.toString());
                }
                uRL = res;
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return uRL;
        }
    }
}

